/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.topology;

import com.ibm.hsc.sfp.topology.NetworkTopology;
import com.ibm.hsc.sfp.topology.NetworkTopologyConstants;
import com.ibm.hsc.sfp.topology.PingNotSupportedException;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class NetworkTopologyNode
implements Serializable,
NetworkTopologyConstants,
Cloneable {
    private HashMap nodeAttributes = new HashMap();
    private ArrayList children = null;
    private String elementName = null;
    private transient HashMap userData = null;
    private static HashMap GIF_NAMES_MAP = null;
    private static HashMap TEXT_MAP = null;
    private static HashMap IDENTIFIER_MAP = null;

    private static synchronized HashMap getGIFNamesMap() {
        if (GIF_NAMES_MAP == null) {
            GIF_NAMES_MAP = new HashMap();
            GIF_NAMES_MAP.put("bpa", "images/D_device.t.gif");
            GIF_NAMES_MAP.put("ethernet_port", "images/D_adapter.t.gif");
            GIF_NAMES_MAP.put("facility", null);
            GIF_NAMES_MAP.put("fsp", "images/D_device.t.gif");
            GIF_NAMES_MAP.put("ib_switch", "images/D_device.t.gif");
            GIF_NAMES_MAP.put("local_hmc", "images/D_console.t.gif");
            GIF_NAMES_MAP.put("lpar", "images/D_console.t.gif");
            GIF_NAMES_MAP.put("managed_system", "images/hsc_managed_sys.t.gif");
            GIF_NAMES_MAP.put("remote_hmc", "images/D_console.t.gif");
        }
        return GIF_NAMES_MAP;
    }

    private static synchronized HashMap getTextMap() {
        if (TEXT_MAP == null) {
            TEXT_MAP = new HashMap();
            TEXT_MAP.put("active", "TOPOLOGY_CONNECTIVITY_ACTIVE");
            TEXT_MAP.put("all_nodes_failed", "TOPOLOGY_ALL_NODES_FAILED");
            TEXT_MAP.put("all_nodes_ok", "TOPOLOGY_ALL_NODES_OK");
            TEXT_MAP.put("full_duplex_link", "TOPOLOGY_FULL_DUPLEX");
            TEXT_MAP.put("half_duplex_link", "TOPOLOGY_HALF_DUPLEX");
            TEXT_MAP.put("no_link", "TOPOLOGY_NO_LINK");
            TEXT_MAP.put("off", "TOPOLOGY_CONNECTIVITY_OFF");
            TEXT_MAP.put("offline", "TOPOLOGY_CONNECTIVITY_OFFLINE");
            TEXT_MAP.put("on", "TOPOLOGY_CONNECTIVITY_ON");
            TEXT_MAP.put("online", "TOPOLOGY_CONNECTIVITY_ONLINE");
            TEXT_MAP.put("some_nodes_failed", "TOPOLOGY_SOME_NODES_FAILED");
            TEXT_MAP.put("unknown", "TOPOLOGY_UNKNOWN");
            TEXT_MAP.put("connectivity_status", "TOPOLOGY_CONNECTIVITY_STATUS");
            TEXT_MAP.put("hostname", "TOPOLOGY_HOSTNAME");
            TEXT_MAP.put("interface", "TOPOLOGY_INTERFACE");
            TEXT_MAP.put("ip_address", "TOPOLOGY_IP_ADDRESS");
            TEXT_MAP.put("link_details", "TOPOLOGY_LINK_DETAILS");
            TEXT_MAP.put("link_speed", "TOPOLOGY_LINK_SPEED");
            TEXT_MAP.put("location_code", "TOPOLOGY_LOCATION_CODE");
            TEXT_MAP.put("lpar_id", "TOPOLOGY_LPAR_ID");
            TEXT_MAP.put("lpar_name", "TOPOLOGY_LPAR_NAME");
            TEXT_MAP.put("mtms", "TOPOLOGY_MTMS");
            TEXT_MAP.put("status", "TOPOLOGY_STATUS");
            TEXT_MAP.put("local_hmc", "TOPOLOGY_LOCAL_HMC");
            TEXT_MAP.put("ethernet_port", "TOPOLOGY_PORT");
            TEXT_MAP.put("fsp", "TOPOLOGY_FSP");
            TEXT_MAP.put("lpar", "TOPOLOGY_LPAR");
            TEXT_MAP.put("managed_system", "TOPOLOGY_MS");
            TEXT_MAP.put("remote_hmc", "TOPOLOGY_REMOTE_HMC");
            TEXT_MAP.put("facility", "TOPOLOGY_FACILITY");
            TEXT_MAP.put("bpa", "TOPOLOGY_BPA");
            TEXT_MAP.put("ib_switch", "TOPOLOGY_IB_SWITCH");
        }
        return TEXT_MAP;
    }

    private static synchronized HashMap getIdentifierMap() {
        if (IDENTIFIER_MAP == null) {
            IDENTIFIER_MAP = new HashMap();
            IDENTIFIER_MAP.put("local_hmc", "hostname");
            IDENTIFIER_MAP.put("ethernet_port", "interface");
            IDENTIFIER_MAP.put("fsp", "hostname");
            IDENTIFIER_MAP.put("lpar", "lpar_name");
            IDENTIFIER_MAP.put("managed_system", "mtms");
            IDENTIFIER_MAP.put("remote_hmc", "hostname");
            IDENTIFIER_MAP.put("facility", "mtms");
            IDENTIFIER_MAP.put("bpa", "hostname");
            IDENTIFIER_MAP.put("ib_switch", "ip_address");
        }
        return IDENTIFIER_MAP;
    }

    NetworkTopologyNode(String string) {
        this.elementName = string;
    }

    public String getElementName() {
        return this.elementName;
    }

    void addChild(NetworkTopologyNode networkTopologyNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (!this.children.contains(networkTopologyNode)) {
            this.children.add(networkTopologyNode);
        }
    }

    public NetworkTopologyNode[] getChildren() {
        return this.children == null ? null : this.children.toArray(new NetworkTopologyNode[this.children.size()]);
    }

    public boolean isTerminal() {
        return this.getChildren() == null || this.getChildren().length == 0;
    }

    public HashMap getAttributes() {
        return this.nodeAttributes;
    }

    public String getAttribute(String string) {
        return (String)this.nodeAttributes.get(string);
    }

    void setAttribute(String string, String string2) {
        this.nodeAttributes.put(string, string2);
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(this.getElementName());
        Iterator iterator = this.getAttributes().keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append(' ');
            stringBuffer.append((String)object);
            stringBuffer.append("=\"");
            String string = this.getAttribute((String)object);
            if (string.indexOf(10) > -1 || string.indexOf(9) > -1) {
                string = NetworkTopologyNode.convertSpecialCharsForXML(string);
            }
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        object = this.getChildren();
        if (object == null || ((NetworkTopologyNode[])object).length == 0) {
            stringBuffer.append("/>");
            stringBuffer.append('\n');
        } else {
            stringBuffer.append('>');
            stringBuffer.append('\n');
            for (int i = 0; i < ((NetworkTopologyNode[])object).length; ++i) {
                stringBuffer.append(object[i].toXML());
            }
            stringBuffer.append("</");
            stringBuffer.append(this.getElementName());
            stringBuffer.append('>');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static String convertSpecialCharsForXML(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                stringBuffer.append("&#x0A;");
                continue;
            }
            if (string2.equals("\t")) {
                stringBuffer.append("&#x09;");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getImageName() {
        String string = this.getElementName();
        return (String)NetworkTopologyNode.getGIFNamesMap().get(string);
    }

    void setUserData(Object object, Object object2) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        this.userData.put(object, object2);
    }

    Object getUserData(Object object) {
        return this.userData == null ? null : this.userData.get(object);
    }

    public int getEvaluatedStatus() {
        int n = -1;
        String string = this.getElementName();
        if (string != null) {
            String string2 = null;
            if (string.equals("facility")) {
                n = 0;
            } else if ((string.equals("lpar") || string.equals("bpa")) && this.getAttribute("connectivity_status") != null) {
                string2 = this.getAttribute("connectivity_status");
                if (string2 != null) {
                    if (string2.equals("offline")) {
                        n = 1;
                    } else if (string2.equals("online")) {
                        n = 0;
                    } else if (string2.equals("active")) {
                        n = 0;
                    } else if (string2.equals("on")) {
                        n = 1;
                    } else if (string2.equals("off")) {
                        n = 1;
                    }
                }
            } else {
                string2 = this.getAttribute("status");
                if (string2 != null) {
                    if (string.equals("managed_system") || string.equals("lpar")) {
                        if (string2.equals("Operating") || string2.equals("Running")) {
                            n = 0;
                        } else if (!string2.equals("unknown")) {
                            n = 1;
                        }
                    } else if (string2.equals("no_link")) {
                        n = 1;
                    } else if (string2.equals("half_duplex_link")) {
                        n = 0;
                    } else if (string2.equals("full_duplex_link")) {
                        n = 0;
                    } else if (string2.equals("offline")) {
                        n = 1;
                    } else if (string2.equals("active")) {
                        n = 0;
                    } else if (string2.equals("on")) {
                        n = 1;
                    } else if (string2.equals("off")) {
                        n = 1;
                    } else if (string2.equals("online")) {
                        n = 0;
                    } else if (string2.equals("all_nodes_failed")) {
                        n = 1;
                    } else if (string2.equals("some_nodes_failed")) {
                        n = 1;
                    } else if (string2.equals("all_nodes_ok")) {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    public String getStatusString() {
        HashMap hashMap = this.getAttributes();
        String string = null;
        if (hashMap.containsKey("status_key") && hashMap.containsKey("status_bundle")) {
            String string2 = this.getAttribute("status_key");
            String string3 = this.getAttribute("status_bundle");
            string = new LocalizableText(string3, string2).toString();
        } else if (hashMap.containsKey("status")) {
            string = NetworkTopologyNode.getBundleText(this.getAttribute("status"));
        }
        return string;
    }

    private static String getBundleText(String string) {
        if (string == null) {
            return "";
        }
        String string2 = (String)NetworkTopologyNode.getTextMap().get(string);
        return string2 == null ? string : new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", string2).toString();
    }

    public String getNodeLabel() {
        String string = this.getElementName();
        String string2 = "";
        String string3 = (String)NetworkTopologyNode.getIdentifierMap().get(string);
        if (string3 != null) {
            string2 = this.getAttribute(string3);
        }
        String string4 = NetworkTopologyNode.getBundleText(string);
        String string5 = this.getStatusString();
        if (string5 == null || string != null && string.equals("bpa")) {
            if (this.getAttributes().containsKey("connectivity_status")) {
                string5 = NetworkTopologyNode.getBundleText(this.getAttribute("connectivity_status"));
            } else if (string5 == null) {
                string5 = "";
            }
        }
        LocalizableText localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "TOPOLOGY_NODE_LABEL_TYPE_NAME_STATUS", (Object[])new String[]{string4, string2, string5});
        return localizableText.toString();
    }

    public String getAttributesString() {
        HashMap hashMap;
        Set set;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getStatusString();
        if (string != null) {
            stringBuffer.append(NetworkTopologyNode.getBundleText("status"));
            stringBuffer.append("\t   ");
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if ((set = (hashMap = this.getAttributes()).keySet()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.equals("status_key") || string2.equals("status_bundle") || string2.equals("status")) continue;
                String string3 = this.getAttribute(string2);
                if (string2.equals("connectivity_status") || string3.equals("unknown")) {
                    string3 = NetworkTopologyNode.getBundleText(string3);
                }
                stringBuffer.append(NetworkTopologyNode.getBundleText(string2));
                stringBuffer.append("\t   ");
                stringBuffer.append(string3);
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    public boolean supportsPing() {
        String string = this.getAttribute("ip_address");
        if (string != null && !string.equals("unknown")) {
            return true;
        }
        String string2 = this.getAttribute("hostname");
        return string2 != null && !string2.equals("unknown");
    }

    public boolean ping(int n, int n2, StringBuffer stringBuffer) throws PingNotSupportedException {
        if (!this.supportsPing()) {
            throw new PingNotSupportedException();
        }
        String string = this.getAttribute("ip_address");
        if (string == null || string.equals("unknown")) {
            string = this.getAttribute("hostname");
        }
        return NetworkTopology.ping(string, n, n2, null, stringBuffer);
    }

    public Object clone() {
        NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode(this.elementName);
        networkTopologyNode.nodeAttributes.putAll(this.nodeAttributes);
        if (this.userData != null) {
            networkTopologyNode.userData = new HashMap();
            networkTopologyNode.userData.putAll(this.userData);
        }
        if (!this.isTerminal()) {
            NetworkTopologyNode[] networkTopologyNodeArray = this.getChildren();
            for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
                networkTopologyNode.addChild((NetworkTopologyNode)networkTopologyNodeArray[i].clone());
            }
        }
        return networkTopologyNode;
    }
}

